# Quick Start: Creating Your First Sparkle Release

This is a streamlined guide to get you up and running with Sparkle updates quickly.

## Prerequisites

1. **Install GitHub CLI** (optional but recommended):
   ```bash
   brew install gh
   gh auth login
   ```

2. **Download Sparkle Tools**:
   - Go to https://github.com/sparkle-project/Sparkle/releases
   - Download the latest release
   - Extract `generate_keys` and `sign_update` to your project root
   - Make them executable: `chmod +x generate_keys sign_update`

## One-Time Setup (5 minutes)

### 1. Add Sparkle Package

In Xcode:
1. File → Add Package Dependencies
2. Enter: `https://github.com/sparkle-project/Sparkle`
3. Version: `2.6.0` or later
4. Add to Tasq target

### 2. Generate Keys

```bash
./generate_keys
```

**Output will look like:**
```
Public key: ABC123...
Private key: XYZ789...
```

### 3. Configure Info.plist

Open `Tasq/Info.plist` and update:

```xml
<key>SUFeedURL</key>
<string>https://raw.githubusercontent.com/YOUR_USERNAME/Tasq/main/appcast.xml</string>

<key>SUPublicEDKey</key>
<string>PASTE_YOUR_PUBLIC_KEY_HERE</string>
```

### 4. Add GitHub Secret

1. Go to your repo → Settings → Secrets and variables → Actions
2. New repository secret:
   - Name: `SPARKLE_PRIVATE_KEY`
   - Value: [paste your private key]
   - ⚠️ **Save this! You can't view it again!**

### 5. Update appcast.xml

Replace `YOUR_GITHUB_USERNAME` with your actual username in:
- `appcast.xml`
- `Tasq/Info.plist`

### 6. Configure Xcode Project

1. Select Tasq target
2. Build Settings:
   - Search "Info.plist File"
   - Set to: `Tasq/Info.plist`
   
3. Signing & Capabilities:
   - Code Signing Entitlements: `Tasq/Tasq.entitlements`
   - Verify "Outgoing Connections (Client)" is checked under App Sandbox

## Creating a Release (2 minutes)

### Using the Script (Easiest)

```bash
# Make script executable (first time only)
chmod +x release.sh

# Create release
./release.sh 0.2.4 "Added cool new features"
```

The script will:
1. ✅ Build and archive the app
2. ✅ Create a signed ZIP
3. ✅ Generate signature
4. ✅ Create GitHub release
5. ⚠️ Prompt you to update appcast.xml

### Manual Process

1. **Build**:
   ```bash
   xcodebuild archive -project Tasq.xcodeproj -scheme Tasq \
     -configuration Release -archivePath ./build/Tasq.xcarchive
   
   xcodebuild -exportArchive -archivePath ./build/Tasq.xcarchive \
     -exportPath ./build -exportOptionsPlist ExportOptions.plist
   ```

2. **Create ZIP**:
   ```bash
   cd build
   ditto -c -k --sequesterRsrc --keepParent Tasq.app Tasq.app.zip
   ```

3. **Sign**:
   ```bash
   ./sign_update build/Tasq.app.zip
   # Copy the output - you'll need it!
   ```

4. **Update appcast.xml** - Add new entry at the top:
   ```xml
   <item>
       <title>Version 0.2.4</title>
       <sparkle:version>3</sparkle:version>
       <sparkle:shortVersionString>0.2.4</sparkle:shortVersionString>
       <description><![CDATA[
           <h2>What's New</h2>
           <ul><li>Your changes</li></ul>
       ]]></description>
       <pubDate>Wed, 12 Feb 2026 12:00:00 +0000</pubDate>
       <enclosure 
           url="https://github.com/YOUR_USERNAME/Tasq/releases/download/v0.2.4/Tasq.app.zip"
           length="FILE_SIZE_FROM_SIGN_UPDATE"
           sparkle:edSignature="SIGNATURE_FROM_SIGN_UPDATE" />
   </item>
   ```

5. **Publish**:
   ```bash
   git add appcast.xml
   git commit -m "Release v0.2.4"
   git push
   
   gh release create v0.2.4 --title "Tasq 0.2.4" \
     --notes "Release notes" build/Tasq.app.zip
   ```

## Testing

1. **Lower your dev build version** to 0.2.2 in Xcode
2. Run the app
3. Right-click menu bar icon → About → Check for Updates
4. Should detect 0.2.3 or higher as available

## Troubleshooting

### "Cannot find updates"
- Check `SUFeedURL` in Info.plist
- Visit the URL in a browser - it should show XML
- Ensure appcast.xml is pushed to GitHub

### "Update improperly signed"
- Public/private key mismatch
- Regenerate keys and update both Info.plist and GitHub secret

### "Build fails"
- Ensure Sparkle package is added
- Check that Info.plist path is correct in build settings
- Verify network client entitlement is enabled

## Checklist for Each Release

- [ ] Bump version in Xcode (Marketing Version + Build Number)
- [ ] Build and archive
- [ ] Create signed ZIP
- [ ] Update appcast.xml with signature
- [ ] Commit and push appcast.xml
- [ ] Create GitHub release with ZIP
- [ ] Test update from older version

## Files You Should Never Commit

- `*.privatekey` - Your private signing key
- `build/` - Build artifacts
- `sign_update`, `generate_keys` - Sparkle tools (users download separately)

## Need Help?

See `SPARKLE_SETUP.md` for detailed documentation.

## Summary

**Setup once:**
1. Add Sparkle package
2. Generate keys → Update Info.plist
3. Add private key to GitHub Secrets

**For each release:**
1. Run `./release.sh VERSION "notes"`
2. Update appcast.xml
3. Push changes

That's it! Your app now auto-updates. 🎉
