# Tasq

**Tasq lives in your menu bar and shows one task at a time. That's it.**

A minimal macOS menu bar app for single-task focus.

## Features

- One task at a time in your menu bar
- Click to add/complete tasks
- Right-click for history (last 5 completed tasks)
- Launch at login
- Auto-updates

## Requirements

macOS 14.0+ (Sonoma or later)

## Installation

### Download
Get the latest release from [Releases](https://github.com/marouanedekkaki/tasq/releases)

### Build from Source
```bash
git clone https://github.com/marouanedekkaki/tasq.git
cd Tasq
open Tasq.xcodeproj
# Press Cmd+R to build and run
```

## Usage

**Add a task:** Click icon → Type → Press Enter  
**Complete task:** Click icon → Click ✓ button  
**View history:** Right-click icon → See completed tasks  
**Settings:** Right-click icon → Launch at Login / Check for Updates

## Development

### Project Structure
```
Tasq/
├── TasqApp.swift              # Main app + AppDelegate
├── TaskManager.swift          # State management
├── Task.swift                 # Task model
├── ContentView.swift          # Main UI
├── CurrentTaskView.swift      # Active task view
├── EmptyStateView.swift       # New task input
└── UpdaterController.swift    # Sparkle updates
```

### Release
```bash
./release.sh 0.2.4 "Release notes"
```

See [RELEASE_GUIDE.md](RELEASE_GUIDE.md) for details.

## License

Copyright © 2026 Marouane Dekkaki. All rights reserved.

Proprietary software. See LICENSE for details.

## Credits

Built with Swift & SwiftUI • Updates by [Sparkle](https://sparkle-project.org)

---

**Made by MAROUANE DEKKAKI with ❤️ for focused productivity**
